"""
Decorate your function
======================
"""

from pathlib import Path
from remote_run.run import (
    ExecutionContext,
    GuixRunner,
    GitProject,
    remote,
    SshExecution,
)

# %%
# Define an execution context
execution_context = ExecutionContext(
    execution=SshExecution(
        machine="shpc0003.ost.ch",
        working_directory=Path("/cluster/raid/home/reza.housseini"),
    ),
    project=GitProject(),
    runner=GuixRunner(channels=Path("channels.scm").read_text()),
)


# %%
# decorate your functions you want to run in the specified
# execution context
@remote(execution_context)
def add(a, b):
    return a + b


# %%
# this call will run on the remote machine specified in execution_context
assert add(1, 2) == 3
