"""
Call by function
================
"""

from pathlib import Path
from remote_run.run import (
    ExecutionContext,
    GuixRunner,
    GitProject,
    run_remote,
    SshExecution,
)

# %%
# Define an execution context
execution_context = ExecutionContext(
    execution=SshExecution(
        machine="shpc0003.ost.ch",
        working_directory=Path("/cluster/raid/home/reza.housseini"),
    ),
    project=GitProject(),
    runner=GuixRunner(channels=Path("channels.scm").read_text()),
)


# %%
# undecorated function we want to run in the specified execution context
def add(a, b):
    return a + b


# %%
# run on the remote machine specified in execution_context using the function call
assert run_remote(lambda: add(1, 2), execution_context=execution_context) == 3
